%function [x_axis,y_axis,z_axis] = get_Vbias_vs_B
%% set the default font size for all figure
set(0,'defaultAxesFontSize',20)

%% ask the user to load the file
uiwait(msgbox('Choose the file(s) you want to analyze'))
[fileName,pathName,~]=uigetfile('*.dat', 'Open file .dat','MultiSelect','on');
%[fileName,pathName,~] = uigetfile('*.dat', 'Open file .dat');

%% get the data by reading the file
if iscell(fileName)
    num_file = length(fileName);
else
    num_file = size(fileName,1);
end
if num_file>1
for i=1:num_file
    file(i) = importdata(fullfile(pathName,fileName{i}));
end
else
    file(1) = importdata(fullfile(pathName,fileName)); 
end

%% ask for the current bias amplification
prompt_Ibias = 'enter the dc Ibias module amplification in Amps';
dlgtitle_Ibias = 'Input';
user_val_Ibias = inputdlg(prompt_Ibias,dlgtitle_Ibias);
Ibias_val = str2num(user_val_Ibias{1});

%% ask for the measured voltage amplification
prompt_Vmeas = 'enter the amplification for measured voltage in Volts';
dlgtitle_Vmeas = 'Input';
user_val_Vmeas = inputdlg(prompt_Vmeas,dlgtitle_Vmeas);
Vmeas_val = str2num(user_val_Vmeas{1});

%% ask for the factor to convert Bx to Btot
prompt_Bx = 'enter the factor for converting Bx (T) to B (T)';
dlgtitle_Bx = 'Input';
user_val_Bx = inputdlg(prompt_Bx,dlgtitle_Bx);
Bx_val = str2num(user_val_Bx{1});

%% Reading the size of Ibias and getting Ibias values
for k=1:num_file 
str_Ibias = char(file(k).textdata(6));
str_split = strsplit(str_Ibias);
size_Ibias(k) = str2num(str_split{3});
Ibias(1:size_Ibias(k),k) = file(k).data(1:size_Ibias(k),1)*Ibias_val;
end

%% Reading the size of Bx
for k=1:num_file
    size_Bx(k,:) = size(file(k).data(:,1))/size_Ibias(k);
end

for k=1:num_file
    s=1;
    Vmeasure = zeros(size_Ibias(k),size_Bx(k,1));
    %Imeasure = zeros(size_Vbias(k),size_Bx(k,1));
    Bx = zeros(1,size_Bx(k,1));
    for i=1:size_Bx(k,1)
        Vmeasure(1:size_Ibias(k),i)=file(k).data(s:s+size_Ibias(k)-1,5)*Vmeas_val;
        %Imeasure(1:size_Vbias(k),i)=file(k).data(s:s+size_Vbias(k)-1,7)*Imeas_val;%lockinX value
        Bx(i)=file(k).data(s,2);
        s=s+size_Ibias(k);
        %p=p+1;
    end
    %% calculating the differential resistance in Ohms
    diff_res = zeros(size_Ibias(k),size_Bx(k,1));
    for i=1:size_Bx(k,1)
        for j=2:size_Ibias(k)-1
            diff_res(j,i) = (Vmeasure(j+1,i)-Vmeasure(j-1,i))/(Ibias(j+1,k)-Ibias(j-1,k));
        end
    end
dVdI(k).all = diff_res;
Bx1(k).all=Bx;
end

[Zmax,max_loc]=max(max(Ibias,[],1));
Ibias_plot=Ibias(:,max_loc);

%% Making sure that all the scans are from positive to negative Bx values
for k=1:num_file
    if Bx1(k).all(1)-Bx1(k).all(2)<0
        Bx1(k).all=flip(Bx1(k).all);
        dVdI(k).all=flip(dVdI(k).all,2);
        %Vmeas(k).all=flip(Vmeas(k).all,2);
    end
    first_element_Bx(k)=Bx1(k).all(1);
end

%% Removing overlapping regions in Bx values and choosing to display only the dVdI for which the Ibias range is shorter
[sort_first_element_Bx, sort_index_1st_element_Bx]=sort(first_element_Bx,'descend');
for k = 1:num_file-1
    kprime= sort_index_1st_element_Bx(k);
    kprime2= sort_index_1st_element_Bx(k+1);
    if Bx1(kprime).all(end)<Bx1(kprime2).all(1)
        for j=1:length(Bx1(kprime).all)
            if Bx1(kprime).all(j)>Bx1(kprime2).all(1)
                %test=1
                Bx_new(j)=Bx1(kprime).all(j);
                dVdI_new(:,j)=dVdI(kprime).all(:,j);
                %Vmeas_new(:,j)=Vmeas(kprime).all(:,j);
            end
            Bx_final(k).final=Bx_new;
            dVdI_final(k).final=dVdI_new;
            %Vmeas_final(k).final=Vmeas_new;
        end
    else
        Bx_final(k).final=Bx1(kprime).all;
        dVdI_final(k).final=dVdI(kprime).all;
        %Vmeas_final(k).final=Vmeas(kprime).all;
    end
end

Bx_final(num_file).final=Bx1(sort_index_1st_element_Bx(num_file)).all;
dVdI_final(num_file).final=dVdI(sort_index_1st_element_Bx(num_file)).all;
%Vmeas_final(num_file).final=Vmeas(sort_index_1st_element_Bx(num_file)).all;
         
%% Plotting them all together
%get the size of all matrices, column1 is the row dimension, column 2 is the column dimension
total_size = 0;
for k=1:num_file
    size_final_matrices(k,:)=size(dVdI_final(k).final);
    total_size=total_size+size_final_matrices(k,2);
end

dVdI_plot=NaN(max(size_Ibias),total_size);%length(Bx) is the total number of columns we will have in the final image
%Vmeas_plot=NaN(max(size_Vbias),total_size);

lim_col1=1;
lim_col2=size_final_matrices(1,2);
%lim_row1=1;
%lim_row2=size_final_matrices(1,1);
for k=1:num_file
    p=1;
    max_row=max(size_final_matrices,[],1);
    lim_row1=(max_row(1,1)-size_final_matrices(k,1))/2+1;
    lim_row2=lim_row1+size_final_matrices(k,1)-1;
    for j=lim_col1:lim_col2
        dVdI_plot(lim_row1:lim_row2,j)=dVdI_final(k).final(:,p);
        %Vmeas_plot(lim_row1:lim_row2,j)=Vmeas_final(k).final(:,p);
        Bx_plot(j)=Bx_final(k).final(p);
        p=p+1;
    end
    if k<num_file
        lim_col1=lim_col2+1;
        lim_col2=lim_col1+size_final_matrices(k+1,2)-1;
%         lim_row1=(size_final_matrices(k,1)-size_final_matrices(k+1,1))/2+lim_row1;
%         lim_row2=size_final_matrices(k+1,1)+lim_row1-1;
    end
end

figure;
x_axis = Bx_plot/Bx_val;
y_axis = Ibias_plot*1e9;%in nA
%y_axis = Vbias_plot*1000;
z_axis = dVdI_plot;
[X,Y] = meshgrid(x_axis,y_axis);
figure1 = pcolor(X,Y,dVdI_plot/1000);
hold on
set(figure1, 'EdgeColor', 'none');
cl=colorbar;
% caxis([2.1*10^-6 4*10^-6])
% cl.Ticks = [2.1*10^-6 2.12*10^-6 2.14*10^-6 2.16*10^-6 2.18*10^-6 2.2*10^-6];
cl.Label.String = 'R (kOhms)';
xlabel('$B_{||}(T)$','Interpreter','latex')
ylabel('$I_{bias}(nA)$','Interpreter','latex');

%end